<?php

namespace App\Http\Controllers;

use App\DimxDim;
use App\TmbhPengumuman;
use App\UbuxDataPaket;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\FilePengumuman;

class TambahanController extends ResponseController
{
    //
    public function getPengumuman(){
        $pengumuman = TmbhPengumuman::get([
            'tmbh_pengumuman.pengumuman_id as id',
            'tmbh_pengumuman.judul as judul',
            'tmbh_pengumuman.kategori as kategori',
            'tmbh_pengumuman.tgl_exp as kadaluarsa',
            'tmbh_pengumuman.created_at as pembuatan'
        ]);

        return $this->successResponse(200,$pengumuman);
    }
    public function getDetailPengumuman($pengumumanId){
        $pengumuman = TmbhPengumuman::where('pengumuman_id','=',$pengumumanId)
            ->first([
                'tmbh_pengumuman.judul as judul',
                'tmbh_pengumuman.kategori as kategori',
                'tmbh_pengumuman.tgl_exp as tglKadaluarsa',
                'tmbh_pengumuman.created_at as tglBuat',
                'tmbh_pengumuman.created_by as pembuat',
                'tmbh_pengumuman.isi as isi'
            ]);
        $namaFile = FilePengumuman::where('pengumuman_id','=',$pengumumanId)->get([
            'nama_file as namaFile',
            'kode_file as kodeFile',
        ]);
        $pengumuman['files'] = $namaFile;
        return $this->successResponse(200,$pengumuman);
    }
    public function getPaket(){
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        $myPaket = UbuxDataPaket::join('dimx_dim','dimx_dim.dim_id','=','ubux_data_paket.dim_id')
            ->join('ubux_r_status_paket','ubux_r_status_paket.status_paket_id','=','ubux_data_paket.status_paket_id')
            ->join('ubux_r_posisi_paket','ubux_r_posisi_paket.posisi_paket_id','=','ubux_data_paket.posisi_paket_id')
            ->where('dimx_dim.user_id','=',$id)
            ->get([
                'ubux_data_paket.diambil_oleh as namaPenerima',
                'ubux_data_paket.tag as tag',
                'ubux_r_status_paket.status as status',
                'ubux_data_paket.tanggal_kedatangan as waktuKedatangan',
                'ubux_data_paket.desc as deskripsi',
                'ubux_data_paket.pengirim as pengirim',
                'ubux_data_paket.data_paket_id as id'
            ]);
        $otherPaket = UbuxDataPaket::join('dimx_dim','dimx_dim.dim_id','=','ubux_data_paket.dim_id')
            ->join('ubux_r_status_paket','ubux_r_status_paket.status_paket_id','=','ubux_data_paket.status_paket_id')
            ->join('ubux_r_posisi_paket','ubux_r_posisi_paket.posisi_paket_id','=','ubux_data_paket.posisi_paket_id')
            ->where('dimx_dim.user_id','!=',$id)
            ->where('ubux_data_paket.status_paket_id','!=',2)
            ->orWhereNull('dimx_dim.user_id')
            ->get([
                'ubux_data_paket.diambil_oleh as namaPenerima',
                'ubux_data_paket.tag as tag',
                'ubux_data_paket.tanggal_kedatangan as waktuKedatangan',
                'ubux_data_paket.desc as deskripsi',
                'ubux_r_status_paket.status as status',
                'ubux_data_paket.pengirim as pengirim',
                'ubux_data_paket.data_paket_id as id'
            ]);
        $data = [
            'myPaket'=>$myPaket,
            'otherPaket' => $otherPaket
        ];
        return $this->successResponse(200,$data);
    }
    public function getDetailPaket($idPaket){
        $myPaket = UbuxDataPaket::join('ubux_r_status_paket','ubux_r_status_paket.status_paket_id','=','ubux_data_paket.status_paket_id')
            ->join('ubux_r_posisi_paket','ubux_r_posisi_paket.posisi_paket_id','=','ubux_data_paket.posisi_paket_id')
            ->where('ubux_data_paket.data_paket_id','=',$idPaket)
            ->get([
                'ubux_data_paket.diambil_oleh as namaPenerima',
                'ubux_data_paket.tag as tag',
                'ubux_data_paket.tanggal_kedatangan as waktuKedatangan',
                'ubux_data_paket.desc as deskripsi',
                'ubux_data_paket.tanggal_diambil as waktuDiambil',
                'ubux_data_paket.pengirim as pengirim',
                'ubux_r_posisi_paket.name as posisiPaket',
                'ubux_r_status_paket.status as statusPaket'
            ]);

        return $this->successResponse(200,$myPaket);
    }
}
